	function Amin = CA_Amin_Z(N, wcT, wsT, Amax)
	
	% 	Computes Amin for a lowpass digital Cauer filter of order N
	% 	while keeping the band edges constant
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2018-04-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi	
	
	if N ~= round(N)
		disp([ 'Must be an integer'])
		break
	end
	A = sqrt(tan(wsT/2)/tan(wcT/2));
    for k = 1:4
        A = A*A;
        A = A+sqrt(A*A-1);
	end
    JJ = 2^(N-1)*A^N;
    for k = 1:4
        JJ = sqrt((JJ+1/JJ)/2);
	end
    Amin = 10*log10(1+(10^(Amax/10)-1)*JJ^4);	
	
